/*
 * Decompiled with CFR 0.152.
 */
package dev.gugle.iss.custom;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gugle.iss.custom.ISSCustom;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class ISSCustomConfig {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public JsonObject config = null;
    Path configPath;

    public ISSCustomConfig(Path configPath) {
        this.configPath = configPath;
        this.readOrCreateConfig();
    }

    public int getMaxRadius() {
        return this.config.has("max_radius") ? this.config.get("max_radius").getAsInt() : Integer.MAX_VALUE;
    }

    public int getMaxRadius(String spell) {
        String fieldName = spell + "_max_radius";
        return this.config.has(fieldName) ? this.config.get(fieldName).getAsInt() : this.getMaxRadius();
    }

    public int getMaxDistance() {
        return this.config.has("max_distance") ? this.config.get("max_distance").getAsInt() : Integer.MAX_VALUE;
    }

    public int getMaxDistance(String spell) {
        String fieldName = spell + "_max_distance";
        return this.config.has(fieldName) ? this.config.get(fieldName).getAsInt() : this.getMaxDistance();
    }

    @NotNull
    private static JsonObject defaultConfig() {
        JsonObject config = new JsonObject();
        config.addProperty("max_radius", (Number)10);
        config.addProperty("max_distance", (Number)10);
        return config;
    }

    public void readOrCreateConfig() {
        ISSCustom.LOGGER.info("Reading or creating config file at {}", (Object)this.configPath);
        File configFile = this.configPath.toFile();
        if (!configFile.exists()) {
            ISSCustom.LOGGER.info("Config file not found, creating one");
            ISSCustom.LOGGER.info("Creating config file at {}", (Object)this.configPath);
            if (!configFile.getParentFile().exists() && !configFile.mkdirs()) {
                ISSCustom.LOGGER.error("Failed to create config directory");
                return;
            }
            try (FileWriter writer = new FileWriter(configFile);){
                this.config = ISSCustomConfig.defaultConfig();
                GSON.toJson((JsonElement)this.config, (Appendable)writer);
            }
            catch (Exception e) {
                ISSCustom.LOGGER.error("Failed to create config file", (Throwable)e);
            }
        } else {
            try (FileReader reader = new FileReader(configFile);){
                this.config = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
            }
            catch (Exception e) {
                ISSCustom.LOGGER.error("Failed to read config file", (Throwable)e);
            }
        }
    }
}

